import hxvlc.flixel.FlxVideoSprite;

var wave:CustomShader = new CustomShader("wave");
weegeeClassic = new Character(0, 0, "classic-weegee", false);
if (FlxG.save.data.midsongvids_toggle) {
	var intro = new FlxVideoSprite(0, 0);
	intro.autoPause = false;
	intro.load(Assets.getPath(Paths.video("dear_weegee")));
	intro.visible = false;
	var spoil = new FlxVideoSprite(0, 0);
	spoil.autoPause = false;
	spoil.load(Assets.getPath(Paths.video("spoiling")));
	spoil.visible = false;
}
function create() {
	if (FlxG.save.data.midsongvids_toggle) {
		intro.bitmap.onFormatSetup.add(function() {
			intro.cameras = [camHUD2];
			intro.scale.set(1.5, 1.5);
			intro.updateHitbox();
		});
		spoil.bitmap.onFormatSetup.add(function() {
			spoil.cameras = [camHUD2];
			spoil.scale.set(1.5, 1.5);
			spoil.updateHitbox();
		});
		add(intro);
		add(spoil);
	}
}

function beatHit() {
	switch (curBeat) {
		case 0:
			if (FlxG.save.data.midsongvids_toggle) {
				intro.play();
				intro.visible = true;
			}
		case 32:
			if (FlxG.save.data.midsongvids_toggle) {
				intro.visible = false;
				remove(intro);
			}
		case 192:
			camHUD.alpha = 0.001;
			camGame.addShader(wave);
			wave.intensity = 50;
			wave.spacing = 30;
			FlxTween.num(50, 250, 10, {ease: FlxEase.circIn}, (val:Float) -> {
				wave.intensity = val;
			});
			camHUD2.flash(FlxColor.BLACK, (Conductor.stepCrochet / 1000) * 128);
		case 226:
			camHUD.zoom = 2;
			camHUD.alpha = 1;
		case 228:
			camGame.removeShader(wave);
		case 292:
			if (FlxG.save.data.midsongvids_toggle) {
				spoil.play();
				spoil.visible = true;
			}
		case 316:
			if (FlxG.save.data.midsongvids_toggle) {
				spoil.visible = false;
				remove(spoil);
			}
		case 446:
			camGame.alpha = 0.001;
		case 448:
			camGame.alpha = 1;
		case 676:
			FlxTween.tween(camHUD, {alpha: 0.001}, (Conductor.stepCrochet / 1000) * 16);
	}
}

var time:Float = 0;

function update(elapsed) {
	wave.iTime = time;
	time += elapsed * 2;
}


/**
 * All video variables should be declared in this array, otherwise the custom focus handler
 * won't happen, and weird behaviour might happen.
 */
 var videosToHandle:Array<FlxVideoSprite> = [intro, spoil];

function onSubstateOpen() {
	// check: should we be playing a video?
	// if yes: pause all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.pause();
			}
		}
	}
}

function onSubstateClose() {
	// check: should we be playing a video?
	// if yes: resume all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.resume();
			}
		}
	}
}

/** NOTE for: onFocusLost() | onFocus()
 * Since hxvlc.flixel.FlxVideo/FlxVideoSprite doesn't have an "isPlaying" variable, we
 * check if the video is visible instead. If it isn't, then the video shouldn't be
 * playing in the first place.								~ xavi. (thatoneidiotxav)
**/
function onFocusLost() {
	// check: should we be playing a video?
	// if yes: run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		// if yes: pause video
		// otherwise: do nothing, videos should already be paused
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.pause();
				}
			}
		}
	}
}

function onFocus() {
	// check: should we be playing a video?
	// if yes, run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.resume();
				}
			}
		}
	}
}
